/* $Id: order.c,v 1.2 2003/03/02 13:53:05 martin Exp $ */

#include <stdio.h>
#include <assert.h>

#include "chess.h"
#include "logger.h"
#include "movegen.h"
#include "attacks.h" /* see */
#include "order.h"
#include "history.h"

#define KILLER_BONUS 80
#define TRANSREF_BONUS 2000 /* should be largest bonus */

/*
  move ordering function to be used in regular search.
  It is called at maximum once per search() call.

  Awards bonus for 
  a) being move from the transposition table
  b) be a winning capture
  c) be a killer
  d) even capture
  e) rest ... normally no bonus.
 
  moves are in move_array[index..end_index].
  use_tt has to be != 0, otherwise no good tt move is assumed.
  n is the search depth remaining, e.g. killers are only taken care
  of in basic search.

  */

int
order_moves(int index,int end_index,int tt_from_to,int use_tt,int n)
{
  int i;

  if(n && KILLERS_ON)
    /* reset killers for NEXT ply */
    reset_killer_use_count(current_ply+1);

  for (i = index; i < end_index; i++)
    {
      /* TT move lookup */
      if(use_tt)
	if(move_array[i].from_to == tt_from_to)
	  /* do whatever needs to be done for the most important move 
	     in the search... */
	  {
	    move_array[i].key = TRANSREF_BONUS;
	    /* should swap moves */
	    use_tt = 0;
	    continue;
	  }
      /* 
	 give bonus to captures and XXX promotions  
	 */
      if(move_array[i].cap_pro)
	{
	  /* for now, just take the see score + some bonus (
	     a capture is an active move after all).
	     */
	  move_array[i].key = see(turn,&move_array[i]) + 30;
	  continue;
	}
	  
      /* finally, reward killers */
      if(n && KILLERS_ON &&
	 ((move_array[i].from_to == Killer[current_ply][0].from_to) ||
	  (move_array[i].from_to == Killer[current_ply][1].from_to)))
	{
	  move_array[i].key = KILLER_BONUS;
	  continue;
	}
      /* here one could do things like centralisation etc. */
    }

  if(use_tt) /* we should have found a killer move */
    {
      printf("warning: TT move not recognized"
	     "(ply %d maxindex:%d 0x%02x-0x%02x\n",
	     current_ply,end_index,GET_FROM(tt_from_to),GET_TO(tt_from_to));
      log_msg("order: no tt move (ply %d 0x%02x-0x%02x\n",
	      current_ply, GET_FROM(tt_from_to),GET_TO(tt_from_to));
    }

  return 0;
}

